texture	g_tex0;
float	g_NumBlur;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
	Texture = (g_tex0);
    MIPFILTER	= LINEAR;
    MAGFILTER	= LINEAR;
    MINFILTER	= LINEAR;
    AddressU	= BORDER;
    AddressV	= BORDER;
};


struct vs_params
{ 
     float4 position 	: POSITION0;
     float2 tex		: TEXCOORD0;
};


//VERTEX SHADER
void vs( in vs_params IN, out vs_params OUT ) 
{
	OUT.position = IN.position;
	
	OUT.tex = IN.tex;
}

//PIXEL SHADER
float4 ps( float2 tex : TEXCOORD0 ) : COLOR
{

	float4 texColor = tex2D(tex0, tex0); 
	
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.001);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.002);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.003);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.004);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.005);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.006);
	texColor += tex2D( tex0, tex0.xy + 20.0f * 0.007);

	texColor = texColor / 8;
	
		
	

	return texColor;
}

technique Default
{
    pass P0
    {
        VertexShader	= compile vs_3_0 vs();
        PixelShader	= compile ps_2_0 ps();
    }
}